import sys
import math

def main():
    data = sys.stdin.read().strip().split()
    if not data:
        return
    it = iter(data)
    n = int(next(it))
    vecs = []
    for i in range(n):
        x = int(next(it)); y = int(next(it))
        ang = math.atan2(y, x)
        if ang < 0:
            ang += 2 * math.pi
        vecs.append((ang, x, y, i+1))  # store 1-based index

    # sort by angle
    vecs.sort(key=lambda t: t[0])

    # duplicate with angle + 2pi for circular sweep
    vecs2 = vecs + [(ang + 2*math.pi, x, y, idx) for (ang, x, y, idx) in vecs]

    best_sq = 0
    best_l = 0
    best_r = 0

    sum_x = 0
    sum_y = 0
    right = 0
    total = len(vecs2)
    # For each left in [0, n-1] expand right while angle < angle[left] + pi
    for left in range(n):
        # expand right as long as we don't include more than n original vectors
        limit = vecs2[left][0] + math.pi  # strict half-plane width pi
        while right < left + n and right < total and vecs2[right][0] < limit:
            _, x, y, _ = vecs2[right]
            sum_x += x
            sum_y += y
            right += 1
        # evaluate current window [left, right-1]
        cur_sq = sum_x * sum_x + sum_y * sum_y
        if cur_sq > best_sq:
            best_sq = cur_sq
            best_l = left
            best_r = right
        # remove left element before moving left forward
        _, lx, ly, _ = vecs2[left]
        sum_x -= lx
        sum_y -= ly

    # collect indices for best window
    res_indices = []
    for i in range(best_l, best_r):
        res_indices.append(vecs2[i][3])
    # they are unique because window size <= n and left < n

    print(len(res_indices))
    if res_indices:
        print(" ".join(map(str, res_indices)))

if __name__ == "__main__":
    main()